﻿--Criando a tabela temporaria
CREATE TABLE #Rsbarras (cd_barras_boleta varchar(250),
						qtde int)



IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[bkp_pg_cred_cod_boleta]') 
					AND type in (N'U')) 
begin

CREATE TABLE [dbo].[bkp_pg_cred_cod_boleta](
	[cd_emp] [int] NOT NULL,
	[cd_filial] [int] NOT NULL,
	[cd_pg_cred] [int] NOT NULL,
	[cd_barras_boleta] [varchar](250) NOT NULL
) ON [PRIMARY]
end




--fazendo o bkp

insert into bkp_pg_cred_cod_boleta
	select 
		cd_emp,
		cd_filial,
		cd_pg_cred,
		cd_barras_boleta		
	from 
		pg_cred cred 
	where
		not exists (select 
						cd_emp 
					from 
						bkp_pg_cred_cod_boleta 
					where 
						cd_emp=cred.cd_emp and 
						cd_filial=cred.cd_filial and 
						cd_pg_cred=cred.cd_pg_cred)


--Inserindo os dados dos clientes na tabela temporaria
INSERT INTO #Rsbarras
	select 
		cd_barras_boleta,
		count(1) 
	from 
		pg_cred 
	where 
		cd_barras_boleta <>''  
	group by  
		cd_barras_boleta having count(1)>1





--Criando variavel que vai receber o codigo do cliente
DECLARE	@cd_barras_boleta varchar(250)


SET NOCOUNT ON
DECLARE Barras_boleta CURSOR FAST_FORWARD FOR SELECT cd_barras_boleta FROM #Rsbarras
OPEN Barras_boleta
FETCH NEXT FROM Barras_boleta INTO @cd_barras_boleta
WHILE @@FETCH_STATUS=0
	Begin
		
		UPDATE 
			pg_cred
		SET 
			cd_barras_boleta = ''
		WHERE	
			cd_barras_boleta=@cd_barras_boleta
			
		FETCH NEXT FROM Barras_boleta INTO @cd_barras_boleta
	End

PRINT 'Conclu�do.'

--Fechando cursos
CLOSE Barras_boleta;
--Desalocando cursos da memoria
DEALLOCATE Barras_boleta;
--Apagando a tabela temporaria
DROP TABLE #Rsbarras;

INSERT INTO PG_CRED_CD_BARRAS 
select 
	C.CD_EMP,
	c.cd_filial,
	C.CD_PG_CRED,
	C.CD_BARRAS_BOLETA
FROM
	pg_cred c 
where 
	c.cd_emp=1 
	and c.cd_barras_boleta NOT in ('')
	and not exists (select cd_emp from pg_cred_cd_barras where cd_emp=c.cd_emp and cd_filial=c.cd_filial and cd_pg_cred = c.cd_pg_cred)